﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <sys/time.h>
#include <nw/snd/fnd/basis/sndfnd_Time.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//----------------------------------------------------------
TimeSpan
Time::Current()
{
    int ret;
    timeval tv;

    ret = gettimeofday(&tv, NULL);
    NW_ASSERT(ret >= 0);

    return TimeSpan( (s64)tv.tv_sec * 1000 + (s64)tv.tv_usec / 1000 );
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromNanoSeconds(s64 value)
{
    return TimeSpan(static_cast<u32>(value / 1000 / 1000));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMicroSeconds(s64 value)
{
    return TimeSpan(static_cast<u32>(value / 1000));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMilliSeconds(s64 value)
{
    return TimeSpan(static_cast<u32>(value));
}

//----------------------------------------------------------
s64
TimeSpan::ToNanoSeconds() const
{
    return m_TickSpan * 1000 * 1000;
}

//----------------------------------------------------------
s64
TimeSpan::ToMicroSeconds() const
{
    return m_TickSpan * 1000;
}

//----------------------------------------------------------
s64
TimeSpan::ToMilliSeconds() const
{
    return m_TickSpan;
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
