﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_Parts.h>
#include <nw/lyt/lyt_Material.h>

namespace nw
{
namespace lyt
{

using namespace math;

Parts::Parts()
: Base()
, m_Layout(NULL)
{
}

Parts::Parts(
        const res::Parts* pBaseBlock,
        const res::Parts* pOverrideBlock,
        const BuildArgSet& buildArgSet
)
: Base(pBaseBlock, buildArgSet)
, m_Layout(NULL)
{
    NW_UNUSED_VARIABLE(pOverrideBlock)
}

Parts::Parts(const Parts& parts)
 : Base(parts)
 , m_Layout(NULL)
{
}

Parts::~Parts()
{
    // OSReport("Parts::~Parts()\n");
}

Pane*
Parts::FindPaneByNameRecursive(const char* findName)
{
    if (internal::EqualsResName(GetName(), findName)) {
        return this;
    } else {
        return NULL;
    }
}

Material*
Parts::FindMaterialByNameRecursive(const char* findName)
{
    u32 nbMaterial = GetMaterialNum();
    for (u32 idx = 0; idx < nbMaterial; ++idx)
    {
        Material* pMaterial = GetMaterial(idx);
        if (pMaterial)
        {
            if (internal::EqualsMaterialName(pMaterial->GetName(), findName))
            {
                return pMaterial;
            }
        }
    }

    return NULL;
}

} // namespace nw::lyt
} // namespace nw
