﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_Common.h>
#include <nw/lyt/lyt_Group.h>
#include <nw/lyt/lyt_Layout.h>
#include <nw/lyt/lyt_Resources.h>
#include <nw/ut/ut_String.h>

namespace nw
{
namespace lyt
{

Group::Group()
 : m_Name("")
 , m_UserAllocated(false)
{
}

Group::Group(const char* name)
 : m_Name(name)
 , m_UserAllocated(false)
{
    NW_ASSERT_NOT_NULL(name);
    NW_ASSERT_MAX(std::strlen(name), GroupNameStrMax);
}

Group::Group(
    const res::Group* pResGroup,
    Pane* pRootPane
)
 : m_Name(pResGroup->name)
 , m_UserAllocated(false)
{
    const char *const paneNameBase = internal::ConvertOffsToPtr<char>(pResGroup, sizeof(res::Group));

    for (int i = 0; i < pResGroup->paneNum; ++i)
    {
        if (Pane* pFindPane = pRootPane->FindPaneByName(paneNameBase + i * ResourceNameStrMax, true))
        {
            AppendPane(pFindPane);
        }
    }
}

Group::Group(
    const Group& group,
    Pane* pRootPane
)
 : m_Name(group.m_Name)
 , m_UserAllocated(false)
{
    const PaneLinkList& list = group.m_PaneLinkList;
    if (pRootPane) {
        for (nw::lyt::PaneLinkList::ConstIterator it = list.GetBeginIter(), it_end = list.GetEndIter(); it != it_end; ++it) {
            AppendPane(pRootPane->FindPaneByName(it->target->GetName()));
        }
    } else {
        for (nw::lyt::PaneLinkList::ConstIterator it = list.GetBeginIter(), it_end = list.GetEndIter(); it != it_end; ++it) {
            AppendPane(it->target);
        }
    }
}

Group::~Group()
{
    // OSReport("Group::~Group()\n");

    for (PaneLinkList::Iterator it = m_PaneLinkList.GetBeginIter(); it != m_PaneLinkList.GetEndIter();)
    {
        PaneLinkList::Iterator currIt = it++;
        m_PaneLinkList.Erase(currIt);
        Layout::DeleteObj(&(*currIt));
    }
}

void
Group::AppendPane(Pane* pPane)
{
    if (PaneLink* pPaneLink = Layout::NewObj<PaneLink>())
    {
        pPaneLink->target = pPane;
        m_PaneLinkList.PushBack(pPaneLink);
    }
}

GroupContainer::~GroupContainer()
{
    // OSReport("GroupContainer::~GroupContainer()\n");

    // Groupの後処理
    for (GroupList::Iterator it = m_GroupList.GetBeginIter(); it != m_GroupList.GetEndIter();)
    {
        GroupList::Iterator currIt = it++;
        m_GroupList.Erase(currIt);
        if (! currIt->IsUserAllocated())
        {
            Layout::DeleteObj(&(*currIt));
        }
    }
}

void
GroupContainer::AppendGroup(Group* pGroup)
{
    m_GroupList.PushBack(pGroup);
}

Group*
GroupContainer::FindGroupByName(const char* findName)
{
    // 子供に一致するものが無いか検索
    GroupList::Iterator it_end = m_GroupList.GetEndIter();
    for (GroupList::Iterator it = m_GroupList.GetBeginIter(); it != it_end; ++it)
    {
        if (internal::EqualsGroupName(it->GetName(), findName))
        {
            return &(*it);
        }
    }

    return 0;
}

} // namespace nw::lyt
} // namespace nw
