﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ctrl/ctrl_TouchOffCheckButton.h>

namespace nw
{
namespace ctrl
{

bool TouchOffCheckButton::ProcessOff()
{
    switch (m_State) {
    case STATE_OFF_IDLE:
        return true;
    case STATE_ON:
        ChangeState(STATE_OFF);
        StartOff();
        return true;
    case STATE_OFF:
        return true;
    case STATE_ON_IDLE:
        ChangeState(STATE_OFF);
        StartOff();
        return true;
    case STATE_DOWN:
        // DOWN中のoffは無視する(DOWNが終わるとoff状態に移行するのでoffする必要がない)
        return true;
    case STATE_DOWN_IDLE:
        return true;
    case STATE_CANCEL:
        return true;
    };

    return true;
}

bool TouchOffCheckButton::ProcessOn()
{
    switch (m_State) {
    case STATE_OFF_IDLE:
        ChangeState(STATE_ON);
        StartOn();
        return true;
    case STATE_ON:
        return true;
    case STATE_OFF:
        ChangeState(STATE_ON);
        StartOn();
        return true;
    case STATE_ON_IDLE:
        return true;
    case STATE_DOWN:
        // DOWN中のonは保持する(down中にもう一度押されたときに、down終了後にon状態になるため)
        return false;
    case STATE_DOWN_IDLE:
        // DOWN中のonが保持されていたらonに移行
        ChangeState(STATE_ON);
        StartOn();
        return true;
    case STATE_CANCEL:
        return false;
    };

    return true;
}

void TouchOffCheckButton::FinishDown()
{
    // 互換性のために、いったんSTATE_DOWN_IDLEにしてからSTATE_OFF_IDLEにします。
    ChangeState(STATE_DOWN_IDLE);
    // NormalButtonのようにON_IDLEに移るのではなく、OFF_IDLEに移る
    ChangeState(STATE_OFF_IDLE);
}

} // namespace nw::ctrl
} // namespace nw
