﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ctrl/ctrl_DefaultControlCreator.h>
#include <nw/ctrl/ctrl_NormalButton.h>
#include <nw/ctrl/ctrl_DecisionButton.h>
#include <nw/ctrl/ctrl_SelectButton.h>
#include <nw/ctrl/ctrl_CheckButton.h>
#include <nw/ctrl/ctrl_TouchOffButton.h>
#include <nw/ctrl/ctrl_TouchOffCheckButton.h>
#include <nw/ctrl/ctrl_DragButton.h>
#include <nw/ctrl/ctrl_TouchDragButton.h>
#include <nw/lyt/lyt_Layout.h>

namespace nw
{
namespace ctrl
{

DefaultControlCreator::DefaultControlCreator(ButtonGroup* buttonGroup)
 : m_ButtonGroup(buttonGroup)
{
}

void DefaultControlCreator::CreateControl(const lyt::ControlSrc& controlSrc, lyt::Layout* layout)
{
    NW_ASSERTMSG(m_ButtonGroup, "m_ButtonGroup must not be NULL for Layout[%s]", layout->GetName());

    if (!m_ButtonGroup)
    {
        return;
    }

    AnimButton* button = NULL;
    if (std::strcmp("NormalButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<NormalButton>();
        static_cast<NormalButton*>(button)->Build(controlSrc, layout);
    } else if (std::strcmp("DecisionButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<DecisionButton>();
        static_cast<DecisionButton*>(button)->Build(controlSrc, layout);
    } else if (std::strcmp("SelectButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<SelectButton>();
        static_cast<SelectButton*>(button)->Build(controlSrc, layout);
    } else if (std::strcmp("CheckButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<CheckButton>();
        static_cast<CheckButton*>(button)->Build(controlSrc, layout);
    } else if (std::strcmp("TouchOffButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<TouchOffButton>();
        static_cast<TouchOffButton*>(button)->Build(controlSrc, layout);
    } else if (std::strcmp("TouchOffCheckButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<TouchOffCheckButton>();
        static_cast<TouchOffCheckButton*>(button)->Build(controlSrc, layout);
    } else if (std::strcmp("DragButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<DragButton>();
        static_cast<DragButton*>(button)->Build(controlSrc, layout);
    } else if (std::strcmp("TouchDragButton", controlSrc.GetControlName()) == 0) {
        button = lyt::Layout::NewObj<TouchDragButton>();
        static_cast<TouchDragButton*>(button)->Build(controlSrc, layout);
    }

    if (button) {
        m_ButtonGroup->GetButtonList().PushBack(button);
    }
}

} // namespace nw::ctrl
} // namespace nw
