﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/ctrl/ctrl_DecisionButton.h>

namespace nw
{
namespace ctrl
{

bool DecisionButton::ProcessOn()
{
    // DOWN状態でアクションを受け付けないように修正します。
    switch (m_State) {
    case STATE_OFF_IDLE:
        ChangeState(STATE_ON);
        StartOn();
        return true;
    case STATE_ON:
        return true;
    case STATE_OFF:
        ChangeState(STATE_ON);
        StartOn();
        return true;
    case STATE_ON_IDLE:
        return true;
    case STATE_DOWN:
        return true;
    case STATE_DOWN_IDLE:
        return true;
    case STATE_CANCEL:
        return false;
    };

    return true;
}

bool DecisionButton::ProcessOff()
{
    // DOWN状態でアクションを受け付けないように修正します。
    switch (m_State) {
    case STATE_OFF_IDLE:
        return true;
    case STATE_ON:
        ChangeState(STATE_OFF);
        StartOff();
        return true;
    case STATE_OFF:
        return true;
    case STATE_ON_IDLE:
        ChangeState(STATE_OFF);
        StartOff();
        return true;
    case STATE_DOWN:
        return true;
    case STATE_DOWN_IDLE:
        return true;
    case STATE_CANCEL:
        return true;
    };

    return true;
}

} // namespace nw::ctrl
} // namespace nw
