﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_Layout.h>
#include <nw/lyt/lyt_ControlCreator.h>
#include <nw/ctrl/ctrl_CheckButton.h>

namespace nw
{
namespace ctrl
{

void CheckButton::Build(const lyt::ControlSrc& controlSrc, lyt::Layout* layout)
{
    AnimButton::Build(controlSrc, layout);

    // Checkアニメの取得
    m_CheckAnimator = layout->CreateGroupAnimatorAuto(controlSrc.FindFunctionalAnimName("Check"), true);
    NW_ASSERTMSG(m_CheckAnimator, "cannot create CheckAnimator[%s] for Layout[%s]", controlSrc.FindFunctionalAnimName("Check"), layout->GetName());
    m_CheckAnimator->StopAtMin();
}

void CheckButton::ForceSetChecked(bool checked)
{
    m_IsChecked = checked;
    if (m_CheckAnimator) {
        if (checked) {
            m_CheckAnimator->StopAtMax();
        } else {
            m_CheckAnimator->StopAtMin();
        }
    }
}

void CheckButton::FinishDown()
{
    // 互換性のために、いったんSTATE_DOWN_IDLEにします。
    ChangeState(STATE_DOWN_IDLE);
    // NormalButtonと同様に、Downアニメが終わった後、ON状態にします。
    ChangeState(STATE_ON_IDLE);
}

void CheckButton::StartDown()
{
    AnimButton::StartDown();

    if (m_CheckAnimator) {
        m_CheckAnimator->Play(lyt::Animator::PLAYTYPE_ONESHOT, m_IsChecked ? -1.f : 1.f);
    }
    m_IsChecked = ! m_IsChecked;
}

bool CheckButton::UpdateDown()
{
    bool retval = AnimButton::UpdateDown();

    if (m_CheckAnimator) {
        if (m_IsChecked) {
            retval = (m_DownAnimator->IsMaxFrame() && m_CheckAnimator->IsMaxFrame());
        } else {
            retval = (m_DownAnimator->IsMaxFrame() && m_CheckAnimator->IsMinFrame());
        }
    }

    return retval;
}

} // namespace nw::ctrl
} // namespace nw
