﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_OSMUTEX_H__
#define NW_WINEXT_OSMUTEX_H__

#include <winext/types.h>

#if defined(__APPLE__)
#include <TargetConditionals.h>
#endif

#if defined(ANDROID) || defined(__APPLE__)
// TODO: 現状 TARGET_OS_IPHONE はトリミングできないため __APPLE__ を使用しています。
#include <pthread.h>
#endif

namespace nw {
namespace internal {
namespace winext {

#define OSMUTEX_TXT_TAG 0x6D557458
#define OSCOND_TXT_TAG 0x634E6456

#if defined(_WIN32)
struct OSMutex
{
    static const int CRITICAL_SECTION_SIZE = 24;
    int area[ CRITICAL_SECTION_SIZE / sizeof(int) ];
};

struct OSCond
{
    u32             txtTag;         // 'cNdV' 0x634E6456
    char *          name;           // debug name or NULL
    u32             os_reserved1;
};
#elif defined(ANDROID) || defined(__APPLE__)
// TODO: 現状 TARGET_OS_IPHONE はトリミングできないため __APPLE__ を使用しています。
struct OSMutex
{
    pthread_mutex_t mutex;
};

struct OSCond
{
    pthread_cond_t cond;
};
#else
#error unsupported platform
#endif

void OSInitMutex   ( OSMutex* mutex );
void OSInitMutexEx ( OSMutex* mutex, char * name );
void OSLockMutex   ( OSMutex* mutex );
void OSUnlockMutex ( OSMutex* mutex );
BOOL OSTryLockMutex( OSMutex* mutex );

void OSInitCond    ( OSCond* cond );
void OSInitCondEx  ( OSCond* cond, char * name );
void OSWaitCond    ( OSCond* cond, OSMutex* mutex );
void OSSignalCond  ( OSCond* cond );

} // namespace winext
} // namespace internal
} // namespace nw

#endif  // NW_WINEXT_OSMUTEX_H__

