﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_OSMESSAGE_H__
#define NW_WINEXT_OSMESSAGE_H__

#define OSMESSAGEQ_TXT_TAG 0x6D536751

namespace nw {
namespace internal {
namespace winext {

typedef struct OSMessageQueue OSMessageQueue;

typedef struct OSMessage OSMessage;
struct OSMessage
{
    void*           message;
    u32             data0;
    u32             data1;
    u32             data2;
};

struct OSMessageQueue
{
    u32             txtTag;         // 'mSgQ' 0x6D536751
    char *          name;           // debug name or NULL
    u32             os_reserved1;

    OSMessage*      msgArray;
    s32             msgCount;
    s32             firstIndex;
    s32             usedCount;
};

// Flags to turn blocking on/off when sending/receiving message
#define OS_MESSAGE_NOBLOCK          (0)
#define OS_MESSAGE_BLOCK            (0x00000001)
#define OS_MESSAGE_HIGH_PRIORITY    (0x00000002)

void OSInitMessageQueue( OSMessageQueue* mq, OSMessage* msgArray, s32 msgCount );
void OSInitMessageQueueEx( OSMessageQueue* mq, OSMessage* msgArray, s32 msgCount, char * name );

BOOL OSSendMessage( OSMessageQueue* mq, OSMessage* msg, s32 flags );
BOOL OSReceiveMessage( OSMessageQueue* mq, OSMessage* msg, s32 flags );
BOOL OSPeekMessage( OSMessageQueue* mq, OSMessage* msg);

#define OSJamMessage(__os_message_queue, __os_message, __os_message_flags)  \
        OSSendMessage((__os_message_queue),                                 \
                      (__os_message),                                       \
                      (__os_message_flags) | OS_MESSAGE_HIGH_PRIORITY)

OSMessageQueue * OSGetSystemMessageQueue(void);

#define OS_SYSTEM_MESSAGE_DATA0_RELEASE_FOREGROUND     0xFACEBACC
#define OS_SYSTEM_MESSAGE_DATA0_ACQUIRED_FOREGROUND    0xFACEF000
#define OS_SYSTEM_MESSAGE_DATA0_EXIT                   0xD1E0D1E0
#define OS_SYSTEM_MESSAGE_DATA0_NETIO_CHANGE           0xAAC0FFEE
#define OS_SYSTEM_MESSAGE_DATA0_HOMEBUTTON_DENIED      0xCCC0FFEE
#define OS_SYSTEM_MESSAGE_DATA0_ROOT_RECYCLE           0xAAFECAAA

#define OS_SYSTEM_MESSAGE_DATA1_RELEASE_FOREGROUND_SHUTDOWN_FLAG    1

} // namespace winext
} // namespace internal
} // namespace nw

#endif  // NW_WINEXT_OSMESSAGE_H__

