﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_OSEVENT_H__
#define NW_WINEXT_OSEVENT_H__

#define OSEVENT_TXT_TAG 0x65566E54

namespace nw {
namespace internal {
namespace winext {

#define OS_EVENT_MANUAL 0
#define OS_EVENT_AUTO   1

typedef struct OSEvent
{
    void* handle;
} OSEvent;

void OSInitEvent(OSEvent *event, BOOL initial_state, s32 mode);
void OSInitEventEx(OSEvent *event, BOOL initial_state, s32 mode, char * name);

void OSSignalEvent(OSEvent *event);
void OSSignalEventAll(OSEvent *event);
void OSWaitEvent(OSEvent *event);
void OSResetEvent(OSEvent *event);
BOOL OSWaitEventWithTimeout(OSEvent *event, OSTimeNanoseconds timeout);

} // namespace winext
} // namespace internal
} // namespace nw

#endif  // NW_WINEXT_OSEVENT_H__

