﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_ENV_INTERFACE_H__
#define NW_WINEXT_ENV_INTERFACE_H__

#include <winext/types.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

// Retrieves null terminated value of the environment variable "key"
// If "key" does not exist, this will return an empty null temrinated string.
// Ragardless, of the size of the receiving buffer, or length of the variable's
// value, returned string is always null terminated.
//
// Arguments:
// key - name of the enfironment variable, null terminated
// value_buf - buffer to store variable's value
// value_buf_size - length of the buffer
//
// Returns:
// 0  - on success
// negative number - on failure
//
// Example:
// char buf[128];
// rv = ENVGetEnvironmentVariable("GHSTOOL", buf, sizeof(buf));
// if (rv == 0) OSReport("envvar value is %s\n", buf);
//
//

#define MAX_ENV_VALUE_SIZE  256

int ENVGetEnvironmentVariable(const char *key, char *value_buf, u32 value_buf_size);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // NW_WINEXT_ENV_INTERFACE_H__
