﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_WINEXT_AI_H_
#define NW_WINEXT_AI_H_

/*---------------------------------------------------------------------------*
 * Includes
 *---------------------------------------------------------------------------*/
#include <winext/types.h>

namespace nw {
namespace internal {
namespace winext {

/*---------------------------------------------------------------------------*
 * Definitions
 *---------------------------------------------------------------------------*/
#define AI_SAMPLERATE_48KHZ  0x00000001   // SRC sample rates for DSP
#define AI_SAMPLERATE_32KHZ  0x00000000

/*---------------------------------------------------------------------------*
 * Types/Declarations
 *---------------------------------------------------------------------------*/
typedef void (*AIDCallback)(void);


typedef enum _AI_EXADDR_STATE {
    AI_EXADDR_NOT_SET = 0,
    AI_EXADDR_SET = 1,
    AI_EXADDR_INVALID =2
} AI_EXADDR_STATE;


typedef enum _AI_CHANNEL
{
    AI_CHANNEL_STEREO,
    AI_CHANNEL_MULTI_PCM,
    AI_CHANNEL_BITSTREAM
}AI_CHANNEL;

/*---------------------------------------------------------------------------*
 * Globals
 *---------------------------------------------------------------------------*/
extern AI_EXADDR_STATE ex_addr_reg_stat;

/*---------------------------------------------------------------------------*
 * Function Prototypes
 *---------------------------------------------------------------------------*/

// AI-FIFO DMA ---------------------------------------------------------------
AIDCallback AIRegisterDMACallback       (AIDCallback callback);
AIDCallback AIDRCRegisterDMACallback    (AIDCallback callback);

void        AIInitDMA                   (u32 start_addr, u32 length);
BOOL        AIGetDMAEnableFlag          (void);
void        AIStartDMA                  (void);
void        AIStopDMA                   (void);
void        AIQuit                      (void);
u32         AIGetDMABytesLeft           (void);

u32         AIGetDMAStartAddr           (void);
u32         AIDRCGetDMAStartAddr        (void);
u32         AIGetDMALength              (void);
u32         AIDRCGetDMALength           (void);

u32         AIGetDSPSampleRate          (void);
void        AISetDSPSampleRate          (u32 rate);

// General/initialization ------------------------------------------------------
//void        AIInit                      (u8*  stack);
void        AIInit                     ( unsigned int deviceId );

BOOL        AICheckInit                 (void);
void        AIReset                     (void);
void        AISetChannel                (AI_CHANNEL channel, BOOL stuffing);

u32 AIGetAudioFrameCount(void);
// Software work around for extended dma memory support until A31
void AIGetDMARange( u32 start_addr, u32* addr_hi, u32* addr_low);

} // namespace winext
} // namespace internal
} // namespace nw

#endif // NW_WINEXT_AI_H_
