﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_VWRLYT_SCREEN_SHOT_WIN_H_
#define NW_VWRLYT_SCREEN_SHOT_WIN_H_

#include <nw/vwrlyt/vwrlyt_Config.h>
#if defined(NW_VWRLYT_ENABLE)

#include <nw/types.h>
#include <nw/ut.h>

namespace nw
{

namespace lyt
{
class Layout;
}

namespace vwrlyt
{

//======================================
// スクリーンショットを取る
//======================================
class ScreenShot
{
public:
    enum State
    {
        cState_NotReady,
        cState_ReadyToTake,
        cState_Done
    };

    ScreenShot()
         : m_state(cState_NotReady)
         , m_frame(0.f)
         , m_fileName(NULL)
         , m_width(720)
         , m_height(1280)
         , m_Buffer(NULL)
    {
    }

    void SetSize(u32 width, u32 height) { m_width = width; m_height = height; }

    void SetFrame(f32 frame) { m_frame = frame; }

    f32 GetFrame() const { return m_frame; }

    void SetFileName(const char* filename) { m_fileName = filename; }

    bool IsNeedToTake() const { return m_fileName != NULL; }

    State GetState() const { return m_state; }

    void Prepare(ut::IAllocator* allocator);

    void Take();

private:
    State m_state;
    f32 m_frame;
    const char* m_fileName;
    u32 m_width;
    u32 m_height;
    u8* m_Buffer;

    static const int cPixelSize = 4;

};

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
#endif // NW_VWRLYT_SCREEN_SHOT_WIN_H_
