﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_VERDEFS_H_
#define NW_VERDEFS_H_

#include <nw/types.h>

#ifdef __cplusplus
extern "C" {
#endif


#define NW_DEF_STR(X)      NW_DEF_VAL(X)
#define NW_DEF_VAL(X)      #X
#define NW_DEF_CAT(X,Y)    X ## Y
#define NW_LIB_CC          NW_DEF_STR(__CWCC__) "_" NW_DEF_STR(__CWBUILD__)


#ifdef NW_DEBUG
#define NW_LIB_VERSION(lib)    \
    const char* NW_ ## lib ## _Version_ = "<< NW    - " #lib " \tdebug build: " __DATE__ " " __TIME__ " (" NW_LIB_CC ") >>"
#endif

#ifdef NW_DEVELOP
#define NW_LIB_VERSION(lib)    \
    const char* NW_ ## lib ## _Version_ = "<< NW    - " #lib " \tdevelopment build: " __DATE__ " " __TIME__ " (" NW_LIB_CC ") >>"
#endif

#ifdef NW_RELEASE
#define NW_LIB_VERSION(lib)    \
    const char* NW_ ## lib ## _Version_ = "<< NW    - " #lib " \trelease   build: " __DATE__ " " __TIME__ " (" NW_LIB_CC ") >>"
#endif


#ifdef __cplusplus
}
#endif


/* NW_VERDEFS_H_ */
#endif
