﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_UT_FRAME_HEAP_H_
#define NW_UT_FRAME_HEAP_H_

#include <nw/ut/ut_HeapBase.h>

namespace nw {
namespace ut {

//! @briefprivate
class FrameHeap : public HeapBase
{
  public:
    static const int FREE_HEAD = (1 << 0);
    static const int FREE_TAIL = (1 << 1);
    static const int FREE_ALL = (FREE_HEAD | FREE_TAIL);

  private:
    struct HeapState
    {
        u32         tagName;            // タグ名
        void*       headAllocator;      // フレームヒープの先頭位置
        void*       tailAllocator;      // フレームヒープの末尾位置
        HeapState*  pPrevState;         // 1 つ前の状態保存へのポインタ

        HeapState() :
          tagName( 0 ),
          headAllocator( NULL ),
          tailAllocator( NULL ),
          pPrevState( NULL )
        {
        }
    };

  public:
    static  FrameHeap* Create( void* startAddress, u32 heapSize, u16 optFlag = 0 );

    void*   Destroy();
    void*   Alloc( u32 size, int alignment = DEFAULT_ALIGNMENT );
    u32     ResizeForMBlock( void* memBlock, u32 newSize );
    u32     GetAllocatableSize( int alignment = DEFAULT_ALIGNMENT );
    void    Free( int mode );
    bool    RecordState( u32 tagName );
    bool    FreeByState( u32 tagName );
    u32     Adjust();

  private:
    bool    IsValid() { return GetSignature() == FRMHEAP_SIGNATURE; }

    void*   AllocFromHead( u32 size, int alignment );
    void*   AllocFromTail( u32 size, int alignment );

    void    FreeHead();
    void    FreeTail();

    void* mHeadAllocator;
    void* mTailAllocator;
    HeapState* mpState;
};


} // nw::ut
} // nw

#endif // NW_UT_FRAME_HEAP_H_
