﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_UT_MESSAGE_QUEUE_H_
#define NW_UT_MESSAGE_QUEUE_H_

#include <nw/config.h>
#include <nw/ut/os/ut_CriticalSection.h>

#if defined(NW_PLATFORM_CAFE)
    #include <cafe/os.h>
#elif defined(NW_PLATFORM_ANDROID)
    #include <semaphore.h>
#elif defined(NW_PLATFORM_IOS)
    #include <dispatch/dispatch.h>
#endif

#if defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    #include <pthread.h>
#endif

namespace nw {
namespace ut {

//---------------------------------------------------------------------------
//! @briefprivate
//! @details MessageQueue を扱うクラスです。
//---------------------------------------------------------------------------
class MessageQueue
{
public:
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    typedef void* MessageType;
    typedef void* BufferType;
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    typedef void* MessageType;
    typedef void* BufferType;
#elif defined(NW_PLATFORM_CAFE)
    typedef void* MessageType;
    typedef OSMessage BufferType;
#endif

    //---------------------------------------------------------------------------
    //! @brief コンストラクタです。
    //---------------------------------------------------------------------------
    MessageQueue();

    //---------------------------------------------------------------------------
    //! @brief デストラクタです
    //---------------------------------------------------------------------------
    ~MessageQueue();

    void Initialize(BufferType* pMessageArray, u32 messageSize);
    void Finalize();

    bool Send(MessageType msg, bool blockFlag);
    bool Jam(MessageType msg, bool blockFlag);
    bool Recv(MessageType* msg, bool blockFlag);

  private:
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    BufferType* m_pMessageArray;
    u32 m_MessageArraySize;
    void* m_hMessageCountSemaphore;
    void* m_hFreeCountSemaphore;
    CriticalSection m_CriticalSection;
    u32 m_ReadPos;
    u32 m_WritePos;
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    BufferType* m_pMessageArray;
    u32 m_MessageArraySize;
    CriticalSection m_CriticalSection;
    u32 m_ReadPos;
    u32 m_WritePos;
#elif defined(NW_PLATFORM_CAFE)
    OSMessageQueue m_MessageQueue;
#endif

#if defined(NW_PLATFORM_ANDROID)
    sem_t m_hMessageCountSemaphore;
    sem_t m_hFreeCountSemaphore;
#elif defined(NW_PLATFORM_IOS)
    dispatch_semaphore_t m_hMessageCountSemaphore;
    dispatch_semaphore_t m_hFreeCountSemaphore;
#endif
};

} // namespace ut
} // namespace nw

#endif // NW_UT_MESSAGE_QUEUE_H_

