﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_UT_EVENT_H_
#define NW_UT_EVENT_H_

#include <nw/config.h>

#if defined(NW_PLATFORM_CAFE)
    #include <cafe/os.h>
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    #include <pthread.h>
#endif

namespace nw {
namespace ut {

//---------------------------------------------------------------------------
//! @briefprivate
//! @details Event を扱うクラスです。
//---------------------------------------------------------------------------
class Event
{
public:
    //---------------------------------------------------------------------------
    //! @brief コンストラクタです。
    //!
    //! @param manualReset 手動リセットか自動リセットかを設定します。
    //! @param initialState 初期状態がシグナル状態かどうかを指定します。
    //---------------------------------------------------------------------------
    Event( bool manualReset, bool initialState );

    //---------------------------------------------------------------------------
    //! @brief デストラクタです
    //---------------------------------------------------------------------------
    ~Event();

    void Signal();
    void Reset();
    void Wait();
    bool TryWait();

  private:
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    void* m_Event;
#elif defined(NW_PLATFORM_CAFE)
    OSEvent m_Event;
#elif defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)
    pthread_cond_t m_EventCond;
    pthread_mutex_t m_EventMutex;
    bool  m_SignalState;
    bool  m_ManualReset;
#endif
};

} // namespace ut
} // namespace nw

#endif // NW_UT_EVENT_H_

