﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_TYPES_H_
#define NW_TYPES_H_

#include <nw/config.h>
#include <nw/assert.h>

#include <cstddef>

#if !defined(NW_DEBUG) && !defined(NW_DEVELOP) && !defined(NW_RELEASE)
#error "Build target is not defined."
#endif

#if !defined(NW_INLINE)
  #define NW_INLINE     inline
#endif

#if !defined(NW_FORCE_INLINE)
  #if defined(NW_DEBUG)
    #define NW_FORCE_INLINE     inline
  #else
    #define NW_FORCE_INLINE     __forceinline
  #endif
#endif

#if !defined( NW_DEV_DISABLED ) // NW_DEV_DISABLED が定義されていたら dev ライブラリを無効化します。
  #define NW_DEV_ENABLED
#endif

#if !defined( NW_RELEASE ) && defined( NW_DEV_ENABLED ) || defined( NW_PLATFORM_WIN32 ) // Cafe で Release 版、もしくは NW_DEV_ENABLED が未定義の場合はデバッグパッドを無効化します。
  #define NW_DEV_PAD_ENABLE
#endif

namespace nw
{
#ifdef NW_COMPILER_WITH_W64
typedef __w64 unsigned long IntPtr; //!< @details :private
typedef __w64 signed long PtrDiff;  //!< @details :private
#else
typedef unsigned long IntPtr;
typedef signed long PtrDiff;
#endif
}

#define NW_CONFIG_USE_STATIC
#ifdef NW_CONFIG_USE_STATIC
#define NW_TABLE_FIELD static const
#else
#define NW_TABLE_FIELD const
#endif

#define NW_DISALLOW_COPY_AND_ASSIGN(TypeName) \
  TypeName(const TypeName&);                  \
  void operator=(const TypeName&)


#ifndef NW_ANY_TO_PTR_VALUE
#define NW_ANY_TO_PTR_VALUE(ptr) reinterpret_cast<nw::IntPtr>(reinterpret_cast<const void*>(ptr))
#endif

#define NW_UNUSED_VARIABLE(Variable) (void)(&Variable);

#if defined(NW_COMPILER_MSVC)
#define NW_ALIGN_VARIABLE(Variable, n) __declspec(align(n)) Variable
#elif defined(NW_COMPILER_RVCT) || defined(NW_COMPILER_GHS) || defined(NW_COMPILER_CLANG)
#define NW_ALIGN_VARIABLE(Variable, n) Variable __attribute__ ((aligned(n)))
#endif

#define NW_INSTANCE(class_name)  (class_name::GetInstance())

/* NW_TYPES_H_ */
#endif
