﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_TIME_MODULE_H_
#define NW_SND_SPY_TIME_MODULE_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/sndspy_SpyData.h>
#include <nw/snd/spy/modules/sndspy_SpyModule.h>

namespace nw {
namespace snd {
namespace spy {

//! @briefprivate
class TimeModule : public SpySimpleModule
{
public:
    //! @brief コンストラクタ
    TimeModule();

    //! @brief SpyFrame をリセットします。
    void ResetSpyFrame();

    //---------------------------------------------------------------------------
    //! @brief         現在のアプリケーションフレームを取得します。
    //!
    //! @return        現在のアプリケーションフレームを返します。
    //!
    //! @sa SetCurrentAppFrame
    //---------------------------------------------------------------------------
    u32 GetCurrentAppFrame() const
    {
        return m_CurrentAppFrame;
    }

    void SetCurrentAppFrame(u32 value)
    {
        m_CurrentAppFrame = value;
    }

    //---------------------------------------------------------------------------
    //! @brief         現在のオーディオフレームを取得します。
    //!
    //! @return        現在のオーディオフレームを返します。
    //!
    //! @sa SetCurrentAudioFrame
    //---------------------------------------------------------------------------
    u32 GetCurrentAudioFrame() const
    {
        return m_CurrentAudioFrame;
    }

    void SetCurrentAudioFrame(u32 value)
    {
        m_CurrentAudioFrame = value;
    }

    //! @brief 現在の時間データを送信します。
    void PushCurrentTimeData();

private:
    u32 GetCurrentSpyFrame() const;

private:
    u32 m_SpyFrameBase;
    volatile u32 m_CurrentAppFrame;
    volatile u32 m_CurrentAudioFrame;
};

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_TIME_MODULE_H_
