﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_PLOT_STATE_H_
#define NW_SND_SPY_PLOT_STATE_H_

#include <nw/snd/spy/fnd/sndspyfnd_base.h>
#include <nw/snd/spy/modules/sndspy_PlotItemPacket.h>
#include <nw/snd/spy/modules/sndspy_PlotModule.h>

namespace nw {
namespace snd {
namespace spy {

class PlotGroup;
class PlotModule;

//! @brief  Spy プロットステートを制御します。
class PlotState
{
public:

#if !defined(NW_SND_SPY_ENABLE)

// public メソッドの空実装
public:
    PlotState() { }

    PlotState(const char* name)
    {
        NW_UNUSED_VARIABLE(name);
    }

    PlotState(const char* name, u8 r, u8 g, u8 b)
    {
        NW_UNUSED_VARIABLE(name );
        NW_UNUSED_VARIABLE(r);
        NW_UNUSED_VARIABLE(g);
        NW_UNUSED_VARIABLE(b);
    }

    bool IsAttached() const { return false; }

    const char* GetName() const { return ""; }

    void SetName(const char* name)
    {
        NW_UNUSED_VARIABLE(name);
    }

    void SetColor(u8 r, u8 g, u8 b)
    {
        NW_UNUSED_VARIABLE(r);
        NW_UNUSED_VARIABLE(g);
        NW_UNUSED_VARIABLE(b);
    }

    void SetGroup(PlotGroup& group)
    {
        NW_UNUSED_VARIABLE(group);
    }

    void SetGroup(PlotGroup* pGroup)
    {
        NW_UNUSED_VARIABLE(pGroup);
    }

    void PlotValue(const char* state)
    {
        NW_UNUSED_VARIABLE(state);
    }

#else

public:
    PlotState();
    PlotState(const char* name);
    PlotState(const char* name, u8 r, u8 g, u8 b);

    virtual ~PlotState();

    bool IsAttached() const { return m_Module != NULL; }

    const char* GetName() const { return m_MetadataPacketPayload.name.text; }
    void SetName(const char* name);

    void SetColor(u8 r, u8 g, u8 b);

    void SetGroup(PlotGroup& group) { SetGroup(&group); }

    void SetGroup(PlotGroup* pGroup);

    void PlotValue(const char* state);

private:
    bool IsRequested() const
    {
        return IsAttached() && m_Module->IsRequested();
    }

    void InitializePacketCommonData();

    PlotState* GetPrev() const { return m_Prev; }
    void SetPrev(PlotState* prev) { m_Prev = prev; }

    PlotState* GetNext() const { return m_Next; }
    void  SetNext(PlotState* next) { m_Next = next; }

    PlotModule* GetModule() const { return m_Module; }

    //! @brief SpyPlotModule との関連付けを解除します。
    void Attach(PlotModule& module);

    //! @brief SpyPlotModule との関連付けを解除します。
    void Detach();

    bool IsMetadataPushed() const { return m_IsMetadataPushed; }
    void InvalidateMetadata() { m_IsMetadataPushed = false; }

    void PushMetaData();

private:
    PlotModule* m_Module;

    PlotGroup* m_Group;

    PlotState* m_Prev;
    PlotState* m_Next;

    SpyPlotItemPacket::StateMetadataPacketPayload m_MetadataPacketPayload;
    SpyPlotItemPacket::StateValuePacketPayload m_ValuePacketPayload;

    bool m_IsMetadataPushed;

    friend class PlotModule;

#endif // NW_SND_SPY_ENABLE
};

} // namespace spy
} // namespace snd
} // namespace nw

#endif // NW_SND_SPY_PLOT_STATE_H_
