﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_PLOT_GROUP_H_
#define NW_SND_SPY_PLOT_GROUP_H_

#include <nw/snd/spy/fnd/sndspyfnd_base.h>
#include <nw/snd/spy/modules/sndspy_PlotModule.h>
#include <nw/snd/spy/modules/sndspy_PlotItemPacket.h>

namespace nw {
namespace snd {
namespace spy {

//! @brief  プロットグループを制御します。
class PlotGroup
{
#if !defined(NW_SND_SPY_ENABLE)

// public メソッドの空実装
public:
    PlotGroup()
    {
    }

    PlotGroup(const char* name)
    {
        NW_UNUSED_VARIABLE(name);
    }

    bool IsAttached() const
    {
        return false;
    }

    const char* GetName() const
    {
        return "";
    }

    void SetName(const char* name)
    {
        NW_UNUSED_VARIABLE( name );
    }

#else // NW_SND_SPY_ENABLE

public:
    PlotGroup();

    PlotGroup(const char* name);

    virtual ~PlotGroup();

    bool IsAttached() const { return m_Module != NULL; }

    const char* GetName() const { return m_MetadataPacketPayload.name.text; }

    void SetName(const char* name);

    //! @briefprivate
    u32 GetGroupId() const { return m_MetadataPacketPayload.id; }

private:
    bool IsRequested() const
    {
        return IsAttached() && m_Module->IsRequested();
    }

    void InitializePacketCommonData();

    PlotGroup* GetPrev() const { return m_Prev; }

    void SetPrev(PlotGroup* prev) { m_Prev = prev; }

    PlotGroup* GetNext() const { return m_Next; }

    void SetNext(PlotGroup* next) { m_Next = next; }

    PlotModule* GetModule() const { return m_Module; }

    void Attach(PlotModule& module);

    void Detach();

    bool IsMetadataPushed() const
    {
        return m_IsMetadataPushed;
    }

    void InvalidateMetadata()
    {
        m_IsMetadataPushed = false;
    }

    void PushMetadata();

    void PushStatePacket();

    void PushDetachPacket();

private:
    PlotModule* m_Module;

    PlotGroup* m_Prev;
    PlotGroup* m_Next;

    SpyPlotItemPacket::GroupMetadataPacketPayload m_MetadataPacketPayload;

    bool m_IsMetadataPushed;

    friend class PlotItem;
    friend class PlotModule;
    friend class PlotState;

#endif // NW_SND_SPY_ENABLE
};

} // namespace spy
} // namespace snd
} // namespace nw

#endif // NW_SND_SPY_PLOT_GROUP_H_
