﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_SPY_PACKET_UTILITY_H_
#define NW_SND_SPY_SPY_PACKET_UTILITY_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/fnd/string/sndspyfnd_String.h>

namespace nw {
namespace snd {
namespace spy {

//! @briefprivate 文字列データ
template<typename TLength, s32 MaxLength>
struct StringData
{
    TLength length;
    char text[MaxLength];

    void Set(const char* srcText)
    {
        if(srcText == NULL)
        {
            length = 0;
            text[0] = '\0';
        }
        else
        {
            nw::snd::spy::internal::fnd::String::Copy(
                this->text,
                MaxLength,
                srcText);
            length = static_cast<TLength>(strlen(this->text));
        }
    }
};

//! @briefprivate 色データ
struct ColorData
{
    u8 r;
    u8 g;
    u8 b;
    u8 a;
};

} // namespace spy
} // namespace snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_SPY_PACKET_UTILITY_H_
