﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_EVENT_H_
#define NW_SND_SPY_FND_EVENT_H_

#if defined(NW_PLATFORM_CAFE)
#include <cafe/os/OSEvent.h>
#endif

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

class Event
{
private:
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    static const u32 CRITICAL_SECTION_SIZE = 24;
#endif

public:
    Event(bool isManual, bool isInitialState);
    ~Event();

public:
    void Wait();
    bool TryWait();
    void Set();
    void Reset();

private:
    void Initialize(bool isManual, bool isInitialState);
    void Finalize();

private:
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    void* m_EventHandle;
#elif defined(NW_PLATFORM_CAFE)
    bool m_IsInitialized;
    u8   m_Padding[3];

    OSEvent m_Event;
#endif
};

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CAFE)
#include <nw/snd/spy/fnd/os/Cafe/sndspyfnd_EventImplCafe.h>
#endif

#endif // NW_SND_SPY_FND_EVENT_H_
