﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_CRITICAL_SECTION_IMPL_CAFE_H_
#define NW_SND_SPY_FND_CRITICAL_SECTION_IMPL_CAFE_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
NW_INLINE
CriticalSection::CriticalSection() :
m_IsInitialized(false)
{
    Initialize();
}

//---------------------------------------------------------------------------
NW_INLINE
CriticalSection::~CriticalSection()
{
    Finalize();
}

//---------------------------------------------------------------------------
NW_INLINE
void
CriticalSection::Enter()
{
    NW_ASSERT(m_IsInitialized);
    OSLockMutex(&m_Mutex);
}

//---------------------------------------------------------------------------
NW_INLINE
bool
CriticalSection::TryEnter()
{
    NW_ASSERT(m_IsInitialized);
    return OSTryLockMutex(&m_Mutex) == TRUE;
}

//---------------------------------------------------------------------------
NW_INLINE
void
CriticalSection::Leave()
{
    NW_ASSERT(m_IsInitialized);
    OSUnlockMutex(&m_Mutex);
}

//---------------------------------------------------------------------------
NW_INLINE
void
CriticalSection::Initialize()
{
    if(m_IsInitialized)
    {
        return;
    }

    OSInitMutex(&m_Mutex);
    m_IsInitialized = true;
}

//---------------------------------------------------------------------------
NW_INLINE
void
CriticalSection::Finalize()
{
    m_IsInitialized = false;
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_SPY_FND_CRITICAL_SECTION_IMPL_CAFE_H_
