﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_HIO_CHANNEL_H_
#define NW_SND_SPY_FND_HIO_CHANNEL_H_

#include "../../sndspy_Config.h"
#ifdef NW_SND_SPY_ENABLE

#if defined(NW_PLATFORM_CAFE)
#include <cafe/hio.h>
#include <nw/snd/spy/fnd/os/sndspyfnd_Event.h>
#endif

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief    HIO チャンネルを制御します。
//---------------------------------------------------------------------------
class HioChannel
{
public: // 型の定義
    //! @brief  ポートの型です。
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    typedef u16 PortType;
    typedef u16 ConstPortType;
#elif defined(NW_PLATFORM_CAFE)
    typedef char* PortType;
    typedef const char* ConstPortType;
#else
#error unsupported platform!
#endif

public: // 定数の定義
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    //! @brief ポートの無効値です。
    static const PortType INVALID_PORT = 0;
#elif defined(NW_PLATFORM_CAFE)
    //! @brief ポートの最大長です。
    static const u32 MAX_PORT_LENGTH = 16;
#endif

public: // コンストラクタ
    HioChannel();

public:
    //! @brief チャンネルを開きます。
    bool Open(PortType port);

    //! @brief チャンネルを閉じます。
    void Close();

    //! @brief 接続します。
    bool Connect();

    //! @brief 切断します。
    void Disconnect();

    //! @brief チャンネルが開かれているかどうかを調べます。
    bool IsOpened() const;

    //! @brief チャンネルが接続されているかどうかを調べます。
    bool IsConnected() const;

    //! @brief ポートを取得します。
    ConstPortType GetPort() const;

    //! @brief チャンネルからデータを読み込みます。
    //! @return 読み込んだバイト数を返します。エラーの場合は-1を返します。
    u32 Read(void* buffer, u32 length);

    //! @brief チャンネルにデータを書き込みます。
    u32 Write(const void* buffer, u32 length);

private:
#if defined(NW_PLATFORM_CAFE)
    static void ConnectionCallback(HIOStatus status, void* context);
#endif

private:
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    PortType  m_Port;
    uptr      m_Socket;
    uptr      m_ClientSocket;
#elif defined(NW_PLATFORM_CAFE)
    char      m_Port[MAX_PORT_LENGTH];
    HIOHandle m_Handle;
    bool      m_IsConnected;

    Event m_ConnectEvent;
#endif
};

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_FND_HIO_CHANNEL_H_
