﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_WAVE_ARCHIVE_FILE_READER_H_
#define NW_SND_WAVE_ARCHIVE_FILE_READER_H_

#include <nw/snd/snd_WaveArchiveFile.h>

namespace nw {
namespace snd {
namespace internal {

class WaveArchiveFileReader
{
public:
    static const u32 SIGNATURE_FILE = NW_UT_MAKE_SIGWORD( 'F', 'W', 'A', 'R' );
    static const u32 SIGNATURE_WARC_TABLE;

    WaveArchiveFileReader( const void* pWaveArchiveFile, bool isIndividual = false );
    WaveArchiveFileReader();
    void Initialize( const void* warcFile, bool isIndividual = false );
    void Finalize();

    // 初期化
    void InitializeFileTable();
    bool IsAvailable() const { return m_pHeader != NULL; }

    u32 GetWaveFileCount() const;
    u32 GetWaveFileSize( u32 waveIndex ) const;
    u32 GetWaveFileOffsetFromFileHead( u32 waveIndex ) const;

    // 一括ロードの場合
    const void* GetWaveFile( u32 waveIndex ) const;

    // 個別ロード時に利用
    const void* SetWaveFile( u32 waveIndex, const void* pWaveFile );
    bool IsLoaded( u32 waveIndex ) const
    {
        if ( m_IsInitialized == false )
        {
            return false;
        }

        if ( GetWaveFile( waveIndex ) != NULL )
        {
            return true;
        }
        return false;
    }

    bool HasIndividualLoadTable() const;

private:
    // 個別ロードされる波形のロード管理テーブル
    struct IndividualLoadTable
    {
        const void* waveFile[1]; // 実際には、 InfoBlockBody.table.count だけ要素が並ぶ
    };

    // アクセサ
    const void* GetWaveFileForWhole( u32 waveIndex ) const
    {
        u32 offset = m_pInfoBlockBody->GetOffsetFromFileBlockBody( waveIndex );
        return ut::AddOffsetToPtr( &m_pHeader->GetFileBlock()->body, offset );
    }
    const void* GetWaveFileForIndividual( u32 waveIndex ) const
    {
        return m_pLoadTable->waveFile[ waveIndex ];
    }


    // データ
    const WaveArchiveFile::FileHeader*      m_pHeader;
    const WaveArchiveFile::InfoBlockBody*   m_pInfoBlockBody;
    IndividualLoadTable*                    m_pLoadTable;
    bool m_IsInitialized;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_WAVE_ARCHIVE_FILE_READER_H_ */

