﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_VOICECOMMAND_H_
#define NW_SND_VOICECOMMAND_H_

#include <nw/types.h>

#if defined( NW_PLATFORM_CAFE )
  #include <cafe/os.h>
  #include <cafe/ax.h>
#else
  #include <winext/cafe/os.h>
  #include <winext/cafe/ax.h>
#endif

#include <nw/snd/snd_Config.h>
#include <nw/snd/snd_Global.h>
#include <nw/snd/snd_Adpcm.h>

#include <nw/snd/snd_Command.h>
#include <nw/snd/snd_CommandManager.h>

/*! @file
    @brief      Voice に関する関数、およびクラス定義
*/

namespace nw  { namespace snd {

namespace internal
{

class AxVoice;
class NwVoice;
class NwVoiceManager;

enum VoiceCommandId
{
    VOICE_COMMAND_ALLOC_VOICE,
    VOICE_COMMAND_FREE_VOICE,
    VOICE_COMMAND_SET_PRIORITY,
    VOICE_COMMAND_PLAY,
    VOICE_COMMAND_PAUSE,
    VOICE_COMMAND_STOP,
    VOICE_COMMAND_APPEND_WAVE_BUFFER,
    VOICE_COMMAND_UPDATE_PARAM
};

struct VoiceCommandAlloc : public Command
{
    u32 voiceId;
    VoiceRendererType rendererType;
    u32 priority;
    void* userId;
    NwVoiceManager* nwVoiceManager;
};

struct VoiceCommandFree : public Command
{
    u32 voiceId;
};

struct VoiceCommandParam : public Command
{
    u32 voiceId;
    VoiceParam voiceParam;
};

struct VoiceCommandPriority : public Command
{
    u32 voiceId;
    u32 priority;
};

struct VoiceCommandPlay : public Command
{
    u32 voiceId;
    SampleFormat        sampleFormat;
    u32                 sampleRate;
    AdpcmParam          adpcmParam;
};

struct VoiceCommandPause : public Command
{
    u32 voiceId;
};

struct VoiceCommandAppendWaveBuffer : public Command
{
    u32 voiceId;
    void* tag;
    const void* bufferAddress;
    u32 sampleLength;
    u32 sampleOffset;
    bool adpcmContextEnable;
    AdpcmContext adpcmContext;
    bool loopFlag;
};

enum VoiceReplyCommandId
{
    VOICE_REPLY_COMMAND_WAVE_BUFFER_UPDATE,
};

struct VoiceReplyCommandWaveBuffer : public Command
{
    const void* tag;
    WaveBuffer::Status status;
//    u32 playPosition;
};

class AxVoiceCommand : public CommandManager
{
public:
    static AxVoiceCommand& GetInstance();

    void Initialize( void* commandBuffer, u32 commandBufferSize )
    {
        CommandManager::Initialize( commandBuffer, commandBufferSize, ProcessCommandList );
    }

private:
    AxVoiceCommand() {}

    static void ProcessCommandList( Command* commandList );
    static void AxVoiceDisposeCallback( AxVoice* voice, void* arg );
};

class NwVoiceCommand : public CommandManager
{
public:
    static NwVoiceCommand& GetInstance();

    void Initialize( void* commandBuffer, u32 commandBufferSize )
    {
        CommandManager::Initialize( commandBuffer, commandBufferSize, ProcessCommandList );
    }

private:
    NwVoiceCommand() {}

    static void ProcessCommandList( Command* commandList );
    static void NwVoiceDisposeCallback( NwVoice* voice, void* arg );
};

class VoiceReplyCommand : public CommandManager
{
public:
    static VoiceReplyCommand& GetInstance();

    void Initialize( void* commandBuffer, u32 commandBufferSize )
    {
        CommandManager::Initialize( commandBuffer, commandBufferSize, ProcessCommandList );
    }

private:
    VoiceReplyCommand() {}

    static void ProcessCommandList( Command* commandList );
};

}}} // namespace nw::snd

#endif //NW_SND_VOICECOMMAND_H_
