﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_THREAD_STACK_H_
#define NW_SND_THREAD_STACK_H_

#include <nw/types.h>

namespace nw {
namespace snd {
namespace internal {

class ThreadStack
{
public:
    ThreadStack() : m_Addr( static_cast<uptr>(NULL) ), m_Size( 0 ) {}
    ~ThreadStack() { Finalize(); }

    void Initialize( uptr ptr, size_t size );
    void Finalize();

    uptr GetStackBottom() const { return m_Addr + m_Size; }
    uptr GetBaseAddress() const { return m_Addr; }

private:
    uptr    m_Addr;
    size_t  m_Size;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_THREAD_STACK_H_ */

