﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_TASK_H_
#define NW_SND_TASK_H_

#include <nw/ut.h>

namespace nw {
namespace snd {
namespace internal {

/* ========================================================================
        Task class
   ======================================================================== */
class TaskManager;

class Task
{
    friend class TaskManager;

public:
    enum Status {
        STATUS_FREE,
        STATUS_APPEND,
        STATUS_EXECUTE,
        STATUS_DONE,
        STATUS_CANCEL
    };

    Task();
    virtual ~Task();

    void SetId( u32 id ) { m_Id = id; }
    Status GetStatus() const { return m_Status; }

    void Wait() { m_Event.Wait(); }
    bool TryWait() { return m_Event.TryWait(); }

protected:
    // タスク処理を実装する
    // NOTE: Execute関数内で、Taskインスタンスを解放しないこと
    virtual void Execute() = 0;
    void InitializeStatus() { m_Status = STATUS_FREE; }

private:
    NW_DISALLOW_COPY_AND_ASSIGN( Task );

    ut::LinkListNode m_TaskLink;
    nw::ut::Event m_Event;
    Status m_Status;
    u32 m_Id;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_TASK_H_ */

