﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_STREAM_SOUND_FILE_PREFETCH_READER_H_
#define NW_SND_STREAM_SOUND_FILE_PREFETCH_READER_H_

#include <nw/snd/snd_StreamSoundPrefetchFile.h>
#include <nw/snd/snd_StreamSoundFileReader.h>
#include <nw/snd/snd_Global.h>
#include <nw/snd/snd_Config.h>
#include <nw/snd/snd_Util.h>

namespace nw {
namespace snd {
namespace internal {

class StreamSoundPrefetchFileReader
{
public:
    struct PrefetchDataInfo
    {
        u32 startFrame;
        u32 prefetchSize;
        const void* dataAddress;
    };

    StreamSoundPrefetchFileReader();
    void Initialize( const void* streamSoundPrefetchFile );
    void Finalize();
    bool IsAvailable() const { return m_pHeader != NULL; }

    bool IsValidFileHeader( const void* streamSoundFile ) const;

    bool ReadStreamSoundInfo( StreamSoundFile::StreamSoundInfo* strmInfo ) const;
    bool ReadDspAdpcmChannelInfo(
            DspAdpcmParam* param,
            DspAdpcmLoopParam* loopParam,
            int channelIndex ) const;
    bool ReadPrefetchDataInfo( PrefetchDataInfo* pDataInfo, int prefetchIndex ) const;

    NW_INLINE u32 GetChannelCount() const
    {
        NW_ASSERT_NOT_NULL( m_pInfoBlockBody );
        return m_pInfoBlockBody->GetChannelInfoTable()->GetChannelCount();
    }

    NW_INLINE u32 GetPrefetchDataCount() const
    {
        NW_ASSERT_NOT_NULL( m_pPrefetchDataBlockBody );
        return m_pPrefetchDataBlockBody->GetPrefetchDataCount();
    }

private:
    const StreamSoundPrefetchFile::FileHeader*            m_pHeader;
    const StreamSoundFile::InfoBlockBody*                 m_pInfoBlockBody;
    const StreamSoundPrefetchFile::PrefetchDataBlockBody* m_pPrefetchDataBlockBody;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_STREAM_SOUND_FILE_READER_H_ */

