﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_STREAM_SOUND_FILE_LOADER_H_
#define NW_SND_STREAM_SOUND_FILE_LOADER_H_

#include <nw/ut.h>
#include <nw/snd/snd_StreamSoundFileReader.h>

namespace nw {
namespace snd {
namespace internal {

/* ========================================================================
        StreamSoundFileLoader class
   ======================================================================== */

class StreamSoundFileLoader
{
public:
    StreamSoundFileLoader()
        : m_pStream( NULL )
    {}

    explicit StreamSoundFileLoader( ut::FileStream* stream )
    : m_pStream( stream )
    {}

    void Initialize( ut::FileStream* stream )
    {
        NW_ASSERT_NOT_NULL(stream);
        m_pStream = stream;
    }
    void Finalize()
    {
        m_pStream = NULL;
    }

    bool LoadFileHeader( StreamSoundFileReader* reader, void* buffer, unsigned long size );

    bool ReadSeekBlockData( u16* yn1, u16* yn2, int blockIndex, int channelCount );
    bool ReadRegionInfo( StreamSoundFile::RegionInfo* info, u32 regionIndex ) const;

private:
    ut::FileStream* m_pStream;
    u32 m_SeekBlockOffset;
    u32 m_RegionDataOffset;
    u16 m_RegionInfoBytes;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_STREAM_SOUND_FILE_LOADER_H_ */

