﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_STREAM_BUFFER_POOL_H_
#define NW_SND_STREAM_BUFFER_POOL_H_

#include <nw/types.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

class StreamBufferPool
{
public:
    void Initialize( void* pBuffer, size_t size, int blockCount );
    void Finalize();

    void* Alloc();
    void Free( void* pPtr );

    size_t GetBlockSize() const { return m_BlockSize; }
#if defined(NW_PLATFORM_CAFE)
    const void* GetBufferAddr() { return m_pBuffer; }
#endif

private:
    static const int BLOCK_MAX = 32; // 8の倍数
    static const int BIT_PER_BYTE = 8;

    void*  m_pBuffer;           //< バッファのアドレス
    size_t m_BufferSize;        //< バッファの全体サイズ
    size_t m_BlockSize;         //< 1 ブロックあたりのバイト数
                                //  (バッファは m_BlockCount 個のブロックに分けて管理される)
    int    m_BlockCount;        //< ブロック数 (最大ストリームチャンネル数と同じ数になる)
    int    m_AllocCount;        //< ブロックの確保数
    u8     m_AllocFlags[ BLOCK_MAX / BIT_PER_BYTE ];
};

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_STREAM_BUFFER_POOL_H_ */

