﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snd/snd_SoundMemoryAllocatable.h
 *
 * @file snd_SoundMemoryAllocatable.h
 */

#ifndef NW_SND_SOUND_MEMORY_ALLOCATABLE_H_
#define NW_SND_SOUND_MEMORY_ALLOCATABLE_H_

#include <nw/types.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief    サウンドデータを配置するためのメモリを確保するためのインターフェイスです。
//!
//!           @ref SoundHeap クラスがこのクラスを継承しています。
//!
//! @see      SoundHeap クラス
//!
//! @date 2011/07/06 NW4F 1.0.0 PR 公開に向けた調整
//---------------------------------------------------------------------------
class SoundMemoryAllocatable
{
public:
    //----------------------------------------
    //! @name デストラクタ
    //@{
    //---------------------------------------------------------------------------
    //! @brief    デストラクタです。
    //!
    //! @date 2011/07/06 NW4F 1.0.0 PR 公開に向けた調整
    //---------------------------------------------------------------------------
    virtual ~SoundMemoryAllocatable() {}
    //@}

    //----------------------------------------
    //! @name ヒープ操作
    //@{
    //---------------------------------------------------------------------------
    //! @brief    メモリ上のヒープからメモリ領域を割り当てます。
    //!
    //!           確保するメモリの先頭アドレスは
    //!           32 バイトアライメントされている必要があります。
    //!
    //! @param[in]    size    確保するメモリサイズです。
    //!
    //! @return   確保したメモリブロックの先頭アドレスを返します。
    //!           確保に失敗した場合は NULL を返さなくてはなりません。
    //!
    //! @date 2011/07/06 NW4F 1.0.0 PR 公開に向けた調整
    //---------------------------------------------------------------------------
    virtual void* Alloc( size_t size ) = 0;
    //@}
};

} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_SOUND_MEMORY_ALLOCATABLE_H_ */

