﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SEQUENCE_SOUND_FILE_READER_H_
#define NW_SND_SEQUENCE_SOUND_FILE_READER_H_

#include <nw/snd/snd_SequenceSoundFile.h>

namespace nw {
namespace snd {
namespace internal {

class SequenceSoundFileReader
{
public:
    static const u32 SIGNATURE_FILE = NW_UT_MAKE_SIGWORD( 'F', 'S', 'E', 'Q' );

    explicit SequenceSoundFileReader( const void* sequenceFile );
    bool IsAvailable() const { return m_pHeader != NULL; }

    const void* GetSequenceData() const;
    bool GetOffsetByLabel( const char* label, u32* offsetPtr ) const;
    const char* GetLabelByOffset( u32 offset ) const;   // 使われない？

    // デバッグ用
    inline int GetLabelCount() const
    {
        return m_pLabelBlockBody->GetLabelCount();
    }
    inline const char* GetLabel( int index ) const
    {
        return m_pLabelBlockBody->GetLabel( index );
    }

private:
    const SequenceSoundFile::FileHeader* m_pHeader;
    const SequenceSoundFile::DataBlockBody* m_pDataBlockBody;
    const SequenceSoundFile::LabelBlockBody* m_pLabelBlockBody;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_SEQUENCE_SOUND_FILE_READER_H_ */

