﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snd/snd_RemoteSpeakerManager.h
 *
 * @file snd_RemoteSpeakerManager.h
 */

#ifndef NW_SND_REMOTE_SPEAKER_MANAGER_H_
#define NW_SND_REMOTE_SPEAKER_MANAGER_H_

#include <nw/types.h>

#if defined( NW_PLATFORM_CAFE )
  #include <cafe/os.h>
  #include <cafe/pads/wpad/wpad.h>
  #define NW_SND_WPAD_MAX_CONTROLLERS WPAD_MAX_CONTROLLERS
#else
  #define NW_SND_WPAD_MAX_CONTROLLERS 4
#endif

#include <nw/snd/snd_RemoteSpeaker.h>

namespace nw {
namespace snd {
namespace internal {

class RemoteSpeakerManager
{
  public:
    static RemoteSpeakerManager& GetInstance();
    RemoteSpeaker& GetRemoteSpeaker( int channelIndex );

    void Initialize();
    void Finalize();

  private:
    RemoteSpeakerManager();

#if defined( NW_PLATFORM_CAFE )
    static const int SAMPLES_PER_AUDIO_PACKET = RemoteSpeaker::SAMPLES_PER_AUDIO_PACKET;

    static void RemoteSpeakerAlarmProc( OSAlarm *alarm, OSContext *context );

    bool m_Initialized;
    OSAlarm m_RemoteSpeakerAlarm;
#endif // defined( NW_PLATFORM_CAFE )
    RemoteSpeaker m_Speaker[ NW_SND_WPAD_MAX_CONTROLLERS ];
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_REMOTE_SPEAKER_MANAGER_H_ */

