﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_PLAYER_HEAP_H_
#define NW_SND_PLAYER_HEAP_H_

#include <nw/snd/snd_SoundMemoryAllocatable.h>
#include <nw/ut/ut_LinkList.h>

namespace nw {
namespace snd {

/* ========================================================================
        type declaration
   ======================================================================== */

class SoundPlayer;

namespace internal {

/* ========================================================================
        class defition
   ======================================================================== */

class PlayerHeap : public SoundMemoryAllocatable
{
public:
    PlayerHeap();
    virtual ~PlayerHeap();

    void AttachSoundPlayer( SoundPlayer* player ) { m_pPlayer = player; }

    bool Create( void* startAddress, size_t size );
    void Destroy();

    // メモリブロックを確保する
    virtual void* Alloc( size_t size );

    // 確保したメモリブロックを全て解放する
    void Clear();

    // ヒープが有効かどうかを調べる
    bool IsValid() const { return m_pAllocAddress != NULL; }

    // ヒープの空き容量を取得する
    size_t GetFreeSize() const;

    enum State
    {
        STATE_CONSTRUCTED,
        STATE_TASK_REGISTERED,
        STATE_TASK_FINISHED,
        STATE_DESTRUCTED
    };
    State GetState() const { return static_cast<State>(m_State); }
    void SetState(State state) { m_State = static_cast<u8>(state); }

private:
    SoundPlayer* m_pPlayer;
    void* m_pStartAddress;
    void* m_pEndAddress;
    void* m_pAllocAddress;
    u8 m_State; // enum State
    u8 padding[3];


public:
    ut::LinkListNode m_Link; // for SoundPlayer::m_PlayerHeapList
};


} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_PLAYER_HEAP_H_ */

