﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_MML_PARSER_H_
#define NW_SND_MML_PARSER_H_

#include <nw/snd/snd_SequenceTrack.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

class MmlSequenceTrack;
class SequenceSoundPlayer;

/* ========================================================================
        class definition
   ======================================================================== */

class MmlParser
{
public:
    static const int PAN_CENTER = 64;
    static const int SURROUND_PAN_CENTER = 64;
    static const int TEMPO_MIN = 0;
    static const int TEMPO_MAX = 1023;

private:
    enum SeqArgType
    {
        SEQ_ARG_NONE,
        SEQ_ARG_U8,
        SEQ_ARG_S16,
        SEQ_ARG_VMIDI,
        SEQ_ARG_RANDOM,
        SEQ_ARG_VARIABLE
    };

public:
    virtual ~MmlParser() {}

    SequenceTrack::ParseResult Parse(
        MmlSequenceTrack* track,
        bool doNoteOn
    ) const;

    static u32 ParseAllocTrack( const void* baseAddress, u32 seqOffset, u32* allocTrack );

    static void EnablePrintVar( bool enble ) { mPrintVarEnabledFlag = enble; }
    static bool IsEnabledPrintVar() { return mPrintVarEnabledFlag; }

protected:
    virtual void CommandProc(
        MmlSequenceTrack* track,
        u32 command,
        s32 commandArg1,
        s32 commandArg2
    ) const;

    virtual void NoteOnCommandProc(
        MmlSequenceTrack* track,
        int key,
        int velocity,
        s32 length,
        bool tieFlag
    ) const;

private:
    static bool mPrintVarEnabledFlag;

    u8   ReadByte( const u8** ptr ) const { return *(*ptr)++; }
    void UnreadByte( const u8** ptr ) const { --(*ptr); }
    u16  Read16( const u8** ptr ) const;
    u32  Read24( const u8** ptr ) const;
    s32  ReadVar( const u8** ptr ) const;
    s32  ReadArg( const u8** ptr, SequenceSoundPlayer* player, SequenceTrack* track, SeqArgType argType ) const;
    vs16* GetVariablePtr( SequenceSoundPlayer* player, SequenceTrack* track, int varNo ) const;
};

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_MML_PARSER_H_ */

