﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_MIDI_STREAM_PARSER_H_
#define NW_SND_MIDI_STREAM_PARSER_H_

#include <nw/types.h>

namespace nw {
namespace snd {
namespace internal {

/* ========================================================================
        class definition
   ======================================================================== */

class MidiStreamParser
{
public:
    typedef void (*MidiCallback)( u8 status, u8 data1, u8 data2, void* arg );

    MidiStreamParser();
    void SetCallback( MidiCallback callback, void* arg );
    void Parse( const void* buffer, unsigned long size );
    void Reset();

private:
    struct MidiMsgBuffer
    {
        const u8* ptr;
        u32 len;
        u32 readPos;
        u32 donePos;
    };

    bool ReadByte( u8* data );
    bool PeakByte( u8* data );
    void BackByte( u8 byte );
    void EatByte();
    void SetMsgBuffer( const void* buffer, u32 len );
    void ParseBuffer();
    void RestBuffer();
    bool SeekStatusByte();

    static bool IsDataByte( u8 b ) { return ( b & 0x80 ) ? false : true; }
    static bool IsStatusByte( u8 b ) { return ( b & 0x80 ) ? true : false; }
    static bool IsRealtimeMesg( u8 b ) { return ( b >= 0xf8 ) ? true : false; }
    static bool IsSystemResetMesg( u8 b ) { return ( b == 0xff ) ? true : false; }

    MidiCallback m_CallbackFunc;
    void* m_pCallbackArg;

    MidiMsgBuffer m_MsgBuffer;
    MidiMsgBuffer m_RestBuffer;

    u8 m_RestBuf[256];
    bool m_IsReset;
    bool m_IsSysEx;
    u8 m_RunningStatus;
    u8 m_BackByte;
    bool m_IsBackByteAvailable;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_MIDI_STREAM_PARSER_H_ */

