﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_I_WAVE_SOUND_FILE_READER_H_
#define NW_SND_I_WAVE_SOUND_FILE_READER_H_

#include <nw/snd/snd_Global.h>      // AUX_BUS_NUM

namespace nw {
namespace snd {
namespace internal {

struct WaveSoundInfo;
struct WaveSoundNoteInfo;

class IWaveSoundFileReader
{
public:
    virtual void Initialize( const void* waveSoundFile ) = 0;
    virtual bool IsAvailable() const = 0;

    virtual u32 GetWaveSoundCount() const = 0;
    virtual u32 GetNoteInfoCount( u32 index ) const = 0;
    virtual u32 GetTrackInfoCount( u32 index ) const = 0;

    virtual bool ReadWaveSoundInfo( WaveSoundInfo* dst, u32 index ) const = 0;
    virtual bool ReadNoteInfo( WaveSoundNoteInfo* dst, u32 index, u32 noteIndex ) const = 0;

protected:
    virtual ~IWaveSoundFileReader() { }
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif /* NW_SND_I_WAVE_SOUND_FILE_READER_H_ */

