﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_GROUP_FILE_H_
#define NW_SND_GROUP_FILE_H_

#include <nw/snd/snd_Util.h>

namespace nw {
namespace snd {
namespace internal {

struct GroupFile
{
    struct InfoBlock;
    struct FileBlock;
    struct InfoExBlock;
    struct InfoBlockBody;
    struct FileBlockBody;
    struct InfoExBlockBody;
    struct GroupItemInfo;
    struct GroupItemInfoEx;

    struct FileHeader : public Util::SoundFileHeader
    {
        const InfoBlock* GetInfoBlock() const;  // ファイル ID をキーとしたテーブルを含む
        const FileBlock* GetFileBlock() const;
        const InfoExBlock* GetInfoExBlock() const;  // アイテム ID をキーとしたテーブルを含む
    };

    struct InfoBlockBody
    {
        // TODO: リファレンスがひとつ多いと思う。
        //       GroupItemInfo 自体が固定長なので、
        //       ここに直接 GroupItemInfo テーブルを埋めればいいのでは？

        // データ
        Util::ReferenceTable referenceTableOfGroupItemInfo;

        // アクセサ
        NW_INLINE u32 GetGroupItemInfoCount() const
        {
            return referenceTableOfGroupItemInfo.count;
        }
        const GroupItemInfo* GetGroupItemInfo( u32 index ) const
        {
            if ( index >= GetGroupItemInfoCount() )
            {
                return NULL;
            }
            return static_cast<const GroupItemInfo*>( ut::AddOffsetToPtr(
                        this, referenceTableOfGroupItemInfo.item[ index ].offset ) );
        }
#if 0
        // データ
        Util::Table<GroupItemInfo> table;

        // アクセサ
        NW_INLINE u32 GetItemCount() const { return table.count; }
        const GroupItemInfo* GetItemInfo( u32 index ) const
        {
            if ( index > GetItemCount() )
            {
                return NULL;
            }
            return &table.item[ index ];
        }
#endif
    };

    struct InfoBlock
    {
        ut::BinaryBlockHeader   header;
        InfoBlockBody           body;
    };

    struct GroupItemInfo
    {
        // データ
#if defined(NW_PLATFORM_CAFE)
        ut::ResU32 fileId;
#else
        u32 fileId;
#endif
        Util::ReferenceWithSize embeddedItemInfo;
            // 埋め込まれたアイテムの場所やサイズを表現します。
            // [場所] ＝ [offset の起点] は、FileBlockBody です。

        static const u32 OFFSET_FOR_LINK    = 0xffffffff;
        static const u32 SIZE_FOR_LINK      = 0xffffffff;

        // アクセサ
        const void* GetFileLocation( const FileBlockBody* fileBlockBody ) const
        {
            // ファイルブロック (ボディ？) のアドレスに、
            // offset 値を足して返す。
            if ( embeddedItemInfo.offset == OFFSET_FOR_LINK )
            {
                return NULL;
            }
            return ut::AddOffsetToPtr( fileBlockBody,
                    embeddedItemInfo.offset );
        }
    };

    struct FileBlockBody
    {
        // プレースホルダ
    };

    struct FileBlock
    {
        ut::BinaryBlockHeader   header;
        FileBlockBody           body;
    };


    struct InfoExBlockBody
    {
        // データ
        Util::ReferenceTable referenceTableOfGroupItemInfoEx;

        // アクセサ
        NW_INLINE u32 GetGroupItemInfoExCount() const
        {
            return referenceTableOfGroupItemInfoEx.count;
        }
        const GroupItemInfoEx* GetGroupItemInfoEx( u32 index ) const
        {
            if ( index >= GetGroupItemInfoExCount() )
            {
                return NULL;
            }
            return static_cast<const GroupItemInfoEx*>( ut::AddOffsetToPtr(
                        this, referenceTableOfGroupItemInfoEx.item[ index ].offset ) );
        }
    };

    struct InfoExBlock
    {
        ut::BinaryBlockHeader   header;
        InfoExBlockBody         body;
    };

    struct GroupItemInfoEx
    {
        // データ
#if defined(NW_PLATFORM_CAFE)
        ut::ResU32 itemId;
        ut::ResU32 loadFlag;  // SoundArchiveLoader::LoadFlag の論理和が入る
#else
        u32 itemId;
        u32 loadFlag;  // SoundArchiveLoader::LoadFlag の論理和が入る
#endif
    };
};


} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_GROUP_FILE_H_ */

