﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * :include nw/snd/snd_FxParam.h
 *
 * @file snd_FxParam.h
 */

#ifndef NW_SND_FX_PARAM_H_
#define NW_SND_FX_PARAM_H_

#include <nw/types.h>

#if defined( NW_PLATFORM_CAFE )
  #include <cafe/axfx.h>
#else
  #include <winext/cafe/axfx.h>
#endif

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief  リバーブの初期反射音モードの列挙型です。
//!
//! @date 2011/08/18 記述を追加
//! @date 2011/07/07 初版
//---------------------------------------------------------------------------
enum FxReverbEarlyReflectionMode
{
    //! 初期反射の遅延を 5 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_5MS  = AXFX_REVERBHI_EXP_EARLY_MODE_5MS,
    //! 初期反射の遅延を 10 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_10MS = AXFX_REVERBHI_EXP_EARLY_MODE_10MS,
    //! 初期反射の遅延を 15 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_15MS = AXFX_REVERBHI_EXP_EARLY_MODE_15MS,
    //! 初期反射の遅延を 20 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_20MS = AXFX_REVERBHI_EXP_EARLY_MODE_20MS,
    //! 初期反射の遅延を 25 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_25MS = AXFX_REVERBHI_EXP_EARLY_MODE_25MS,
    //! 初期反射の遅延を 30 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_30MS = AXFX_REVERBHI_EXP_EARLY_MODE_30MS,
    //! 初期反射の遅延を 35 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_35MS = AXFX_REVERBHI_EXP_EARLY_MODE_35MS,
    //! 初期反射の遅延を 40 ms に設定します。
    FX_REVERB_EARLY_REFLECTION_40MS = AXFX_REVERBHI_EXP_EARLY_MODE_40MS
};

//---------------------------------------------------------------------------
//! @brief  リバーブの反響音モードの列挙型です。
//!
//! @date 2011/08/18 記述を追加
//! @date 2011/07/07 初版
//---------------------------------------------------------------------------
enum FxReverbFusedMode
{
    //! 以前のバージョンと互換性のある反響音モードです。
    FX_REVERB_FUSED_OLD_AXFX   = AXFX_REVERBHI_EXP_FUSED_MODE_OLD_AXFX,
    //! 金属的な反響音モードです。
    FX_REVERB_FUSED_METAL_TANK = AXFX_REVERBHI_EXP_FUSED_MODE_METAL_TANK,
    //! 小さな室内の反響音モードです。
    FX_REVERB_FUSED_SMALL_ROOM = AXFX_REVERBHI_EXP_FUSED_MODE_SMALL_ROOM,
    //! 大きな室内の反響音モードです。
    FX_REVERB_FUSED_LARGE_ROOM = AXFX_REVERBHI_EXP_FUSED_MODE_LARGE_ROOM,
    //! ホールの反響音モードです。
    FX_REVERB_FUSED_HALL       = AXFX_REVERBHI_EXP_FUSED_MODE_HALL,
    //! 洞窟のような反響音モードです。
    FX_REVERB_FUSED_CAVERNOUS  = AXFX_REVERBHI_EXP_FUSED_MODE_CAVERNOUS
};

} // namespace nw::snd
} // namespace nw

#endif /* NW_SND_FX_PARAM_H_ */
