﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DEBUG_H_
#define NW_SND_DEBUG_H_

//#define NW_SND_LOG_CATEGORY_APICALL_SDK_LOW_ENABLED

#define NW_SND_LOG_CATEGORY_APICALL_NW "NW>"
#define NW_SND_LOG_CATEGORY_APICALL_SDK "AX>"
#define NW_SND_LOG_CATEGORY_APICALL_SDK_LOW "AXL>"

#define NW_SND_LOG_OUTPUT_CONSOLE ( 1 << 0 )
#define NW_SND_LOG_OUTPUT_SPY ( 1 << 1 )

#include <nw/types.h>

#if !defined( NW_RELEASE )

#define NW_SND_LOG(category, ... ) nw::snd::internal::Debug_OutputLog( category, __VA_ARGS__ )

#else

#define NW_SND_LOG( category, ... ) ((void)0)

#endif

#define NW_SND_LOG_APICALL_NW( ... ) NW_SND_LOG( NW_SND_LOG_CATEGORY_APICALL_NW, __VA_ARGS__ )
#define NW_SND_LOG_APICALL_SDK( ... ) NW_SND_LOG( NW_SND_LOG_CATEGORY_APICALL_SDK, __VA_ARGS__ )

#if defined(NW_SND_LOG_CATEGORY_APICALL_SDK_LOW_ENABLED)
#define NW_SND_LOG_APICALL_SDK_LOW( ... ) NW_SND_LOG( NW_SND_LOG_CATEGORY_APICALL_SDK_LOW, __VA_ARGS__ )
#else
#define NW_SND_LOG_APICALL_SDK_LOW( ... ) ((void)0)
#endif

namespace nw {
namespace snd {

//! @briefprivate
enum DebugWarningFlag
{
    DEBUG_WARNING_NOT_ENOUGH_INSTANCE,
    DEBUG_WARNING_NOT_ENOUGH_SEQSOUND,
    DEBUG_WARNING_NOT_ENOUGH_STRMSOUND,
    DEBUG_WARNING_NOT_ENOUGH_WAVESOUND,
    DEBUG_WARNING_NOT_ENOUGH_SEQTRACK,
    DEBUG_WARNING_NOT_ENOUGH_STRMCHANNEL
};

//! @briefprivate
//! @param warning :private
//! @param enable :private
void Debug_SetWarningFlag( DebugWarningFlag warning, bool enable );


/* ========================================================================
        非公開
   ======================================================================== */

namespace internal {

enum DebugSoundType
{
    DEBUG_SOUND_TYPE_SEQSOUND,
    DEBUG_SOUND_TYPE_STRMSOUND,
    DEBUG_SOUND_TYPE_WAVESOUND
};

bool Debug_GetWarningFlag( DebugWarningFlag warning );
DebugWarningFlag Debug_GetDebugWarningFlagFromSoundType( DebugSoundType type );
const char* Debug_GetSoundTypeString( DebugSoundType type );

typedef void (*DebugLogFunc)( const char* text );

extern DebugLogFunc g_DebugLogHookFunc;

inline void Debug_HookLogFunc( DebugLogFunc func ) { g_DebugLogHookFunc = func; }

#if !defined( NW_RELEASE )
void Debug_OutputLog( const char* category, const char* message, ... );
#endif

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_DEBUG_H_ */

