﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CURVE_LFO_H_
#define NW_SND_CURVE_LFO_H_

#include <nw/types.h>

namespace nw {
namespace snd {
namespace internal {

/* ========================================================================
        structure definition
   ======================================================================== */

struct CurveLfoParam
{
    f32 depth;
    f32 speed;   // [Hz]
    u32 delay;
    u8  range;
    u8  curve; // enum Curve
    u8  phase;
    u8  padding;

    enum CurveType
    {
        CURVE_SINE,
        CURVE_MIN = CURVE_SINE,
        CURVE_TRIANGLE,
        CURVE_SAW,
        CURVE_SQUARE,
        CURVE_RANDOM,
        CURVE_USER_MIN = 64,
        CURVE_USER_MAX = 127,
        CURVE_MAX = CURVE_USER_MAX,
        CURVE_COUNT
    };
    CurveLfoParam() { Initialize(); }
    void Initialize();
};

/* ========================================================================
        class definition
   ======================================================================== */

class CurveLfo
{
public:
    CurveLfo() : m_DelayCounter(0), m_Counter( 0.0f ), m_RandomValue(1.0f),
                 m_IsStart(false), m_IsNext(false) {}
    void Reset();

    void Update( int msec );
    f32  GetValue() const;

    void SetParam( const CurveLfoParam& lfoParam ) { m_Param = lfoParam; /* copy */ }
    CurveLfoParam& GetParam() { return m_Param; }
    const CurveLfoParam& GetParam() const { return m_Param; }

    typedef f32 (*CurveFunc)(f32 arg);

    static void InitializeCurveTable();
    static CurveFunc RegisterUserCurve(CurveFunc userCurve, u32 index); // index は 0～63
    static CurveFunc UnregisterUserCurve(u32 index); // index は 0-63

private:
    CurveLfoParam m_Param;
    u32      m_DelayCounter;
    f32      m_Counter;
    mutable f32 m_RandomValue;
    bool     m_IsStart;
    bool     m_IsNext;
    u8       padding[2];
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_CURVE_LFO_H_ */

