﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CONFIG_H_
#define NW_SND_CONFIG_H_

#include <nw/config.h>

#if defined( NW_PLATFORM_CAFE )
    #include <sdk_ver.h>
    #include <cafe/ax.h>
#elif defined( NW_PLATFORM_WIN32 )
    #include <winext/cafe/ax.h>
#elif defined( NW_PLATFORM_ANDROID ) || defined( NW_PLATFORM_IOS )
    #include <winext/cafe/ax.h>
#elif defined(NW_USE_NINTENDO_SDK)
    // TODO: nn_audio
    #include <winext/cafe/ax.h>
#endif

#include <nw/ut/ut_FileStream.h>

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK) || defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS) || (CAFE_OS_SDK_VERSION >= 20700)
    #define NW_SND_CONFIG_ENABLE_APPFRAMECALLBACK
#endif

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK) || defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS) || (CAFE_OS_SDK_VERSION >= 21001)
#define NW_SND_CONFIG_ENABLE_MULTICHEFT
#endif

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK) || defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)|| (CAFE_OS_SDK_VERSION >= 21100)
#define NW_SND_CONFIG_ENABLE_6CHAAC
#endif

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK) || defined(NW_PLATFORM_ANDROID) || defined(NW_PLATFORM_IOS)|| (CAFE_OS_SDK_VERSION >= 21101)
//#define NW_SND_CONFIG_ENABLE_SOUND2
#endif

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
#define NW_SND_CONFIG_ENABLE_DEV
#endif

namespace nw {

namespace ut { class FileStream; }

namespace snd {
namespace internal {

typedef ut::FileStream FileStream;

static const u32 STRM_CHANNEL_NUM = 16;
static const u32 STRM_TRACK_NUM = 8;
static const u32 STRM_CHANNEL_NUM_PER_TRACK = 2;
static const u32 STRM_DATA_LOAD_TASK_MAX = 32;

// 1 ブロックのマージン [サンプル数]
// (48KHz の波形が 8 倍のピッチで 3ms 以内に再生できるサンプル数)
//   48KHz : ユーザーが利用するであろう最大サンプリングレート。
//   8倍   : AX のボイスに設定できる最大ピッチ。
//   3ms   : AX 割り込み周期。
static const u32 DATA_BLOCK_SIZE_MARGIN_SAMPLES = 48000 * 8 * 3 / 1000;

} // namespace internal
} // namespace snd
} // namespace nw

#endif /* NW_SND_CONFIG_H_ */

