﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CHANNEL_MANAGER_H_
#define NW_SND_CHANNEL_MANAGER_H_

#include <nw/snd/snd_Channel.h>
#include <nw/snd/snd_InstancePool.h>
#include <nw/ut/ut_LinkList.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

class ChannelManager
{
public:
    static ChannelManager& GetInstance();

    size_t GetRequiredMemSize( int channelCount );
    void Initialize( void* mem, unsigned long memSize );
    void Finalize();
    Channel* Alloc();
    void Free( Channel* channel );

    void UpdateAllChannel();

private:
    typedef InstancePool<Channel> ChannelPool;
    typedef ut::LinkList< Channel, offsetof(Channel,m_Link)> ChannelList;

    ChannelManager();

    ChannelPool m_Pool;
    ChannelList m_ChannelList;
    bool m_IsInitialized;
    unsigned long m_ChannelCount;
};

} // namespace nw::snd::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_CHANNEL_MANAGER_H_ */

