﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_CACHED_FS_FILE_STREAM_H_
#define NW_SND_CACHED_FS_FILE_STREAM_H_

#include <nw/snd/snd_FsFileStream.h>

namespace nw {
namespace snd {
namespace internal {

//---------------------------------------------------------------------------
//! @brief  キャッシュ付き FS ファイルストリームクラスです。
//!
//!         Read 範囲がキャッシュにおさまっている場合は FS にアクセスしません。
//!         また、FS をリードする際、最低 m_CacheSize バイトかならず読み込みます。
//---------------------------------------------------------------------------
class CachedFsFileStream : public FsFileStream
{
//------ publicメンバ --------------------------
public:
    NW_UT_RUNTIME_TYPEINFO( nw::ut::FileStream );  // ダウンキャスト用の実行時型情報を埋め込みます

    CachedFsFileStream();

    void SetCacheBuffer(void* bufferAddress, size_t size);
    void ClearCacheBuffer();

    virtual s32 Read(void* buf, u32 length);
    virtual bool Seek(s32 offset, u32 origin);
    virtual u32 Tell() const;

private:
    bool IsCacheAvailable() const;
    bool IsInCache(u32 length) const;
    void* m_pCacheBuffer;
    size_t m_CacheSize;
    s32 m_CachePos;
    s32 m_VirtualFilePos;
};

}}} // namespace nw::snd::internal


/* NW_SND_CACHED_FS_FILE_STREAM_H_ */
#endif
