﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_BIQUAD_FILTER_PRESETS_H_
#define NW_SND_BIQUAD_FILTER_PRESETS_H_

#include <nw/snd/snd_BiquadFilterCallback.h>

namespace nw {
namespace snd {
namespace internal {

/* ------------------------------------------------------------------------
        BiquadFilterLpf - ローパスフィルタ
        （1/16オクターブ間隔、チェビシェフ近似）
   ------------------------------------------------------------------------ */
class BiquadFilterLpf : public BiquadFilterCallback
{
public:
    BiquadFilterLpf() {}
    virtual void GetCoefficients( int type, f32 value, Coefficients* coef ) const;

private:
    static const int COEFFICIENTS_TABLE_SIZE = 112;
    static const Coefficients COEFFICIENTS_TABLE[ COEFFICIENTS_TABLE_SIZE ];
};

/* ------------------------------------------------------------------------
        BiquadFilterHpf - ハイパスフィルタ
        （1/16オクターブ間隔、チェビシェフ近似）
   ------------------------------------------------------------------------ */
class BiquadFilterHpf : public BiquadFilterCallback
{
public:
    BiquadFilterHpf() {}
    virtual void GetCoefficients( int type, f32 value, Coefficients* coef ) const;

private:
    static const int COEFFICIENTS_TABLE_SIZE = 97;
    static const Coefficients COEFFICIENTS_TABLE[ COEFFICIENTS_TABLE_SIZE ];
};

/* ------------------------------------------------------------------------
        BiquadFilterBpf512 - バンドパスフィルタ
        （中心周波数 512Hz、チェビシェフ近似）
   ------------------------------------------------------------------------ */
class BiquadFilterBpf512 : public BiquadFilterCallback
{
public:
    BiquadFilterBpf512() {}
    virtual void GetCoefficients( int type, f32 value, Coefficients* coef ) const;

private:
    static const int COEFFICIENTS_TABLE_SIZE = 122;
    static const Coefficients COEFFICIENTS_TABLE[ COEFFICIENTS_TABLE_SIZE ];
};

/* ------------------------------------------------------------------------
        BiquadFilterBpf1024 - バンドパスフィルタ
        （中心周波数 1024Hz、チェビシェフ近似）
   ------------------------------------------------------------------------ */
class BiquadFilterBpf1024 : public BiquadFilterCallback
{
public:
    BiquadFilterBpf1024() {}
    virtual void GetCoefficients( int type, f32 value, Coefficients* coef ) const;

private:
    static const int COEFFICIENTS_TABLE_SIZE = 93;
    static const Coefficients COEFFICIENTS_TABLE[ COEFFICIENTS_TABLE_SIZE ];
};

/* ------------------------------------------------------------------------
        BiquadFilterBpf2048 - バンドパスフィルタ
        （中心周波数 2048Hz、チェビシェフ近似）
   ------------------------------------------------------------------------ */
class BiquadFilterBpf2048 : public BiquadFilterCallback
{
public:
    BiquadFilterBpf2048() {}
    virtual void GetCoefficients( int type, f32 value, Coefficients* coef ) const;

private:
    static const int COEFFICIENTS_TABLE_SIZE = 93;
    static const Coefficients COEFFICIENTS_TABLE[ COEFFICIENTS_TABLE_SIZE ];
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_BIQUAD_FILTER_PRESETS_H_ */

