﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_ANIM_EVENT_PLAYER_H_
#define NW_SND_ANIM_EVENT_PLAYER_H_

#if defined( NW_PLATFORM_CTR )
    #include <nn/types.h>
#elif defined( NW_PLATFORM_CAFE )
    #include <nw/types.h>
#endif
#include <nw/snd/snd_AnimSoundFile.h>
#include <nw/snd/snd_SoundHandle.h>

namespace nw {
namespace snd {

class SoundStartable;

namespace internal {

class AnimEventPlayer
{
public:
    AnimEventPlayer();
    ~AnimEventPlayer();

    void Initialize();
    void Finalize();

    bool IsPlaying( const AnimSoundFile::EventInfo& eventInfo ) const
    {
        return &eventInfo == m_pEventInfo;
    }
    bool IsAttachedSound() const { return m_Handle.IsAttachedSound(); }
    int GetPlayingSoundPriority() const
    {
        if ( ! IsAttachedSound() )
        {
            return 0;
        }
        return m_Handle.detail_GetAttachedSound()->GetPlayerPriority();
    }

    void UpdateFrame();

    bool StartEvent(
            const AnimSoundFile::EventInfo& eventInfo,
            SoundStartable& starter,
            bool isStopWhenFinalize );
    bool HoldEvent(
            const AnimSoundFile::EventInfo& eventInfo,
            SoundStartable& starter,
            bool isStopWhenFinalize );
    void StopEvent( const AnimSoundFile::EventInfo& eventInfo )
    {
        if ( m_pEventInfo == &eventInfo )
        {
            ForceStop();
        }
    }

    void ForceStop();
    void WritePlaySpeedToSequenceVariable( u8 sequenceVariableNo, f32 speed );

private:
    void InitParam( const AnimSoundFile::EventInfo& eventInfo, bool isStopWhenFinalize );

    SoundHandle m_Handle;
    const AnimSoundFile::EventInfo* m_pEventInfo;
    bool m_IsStopWhenFinalize;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_ANIM_EVENT_PLAYER_H_ */

