﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_WAVEFORM_STREAM_H_
#define NW_SND_FND_WAVEFORM_STREAM_H_

#include <nw/ut/ut_Inlines.h>
#include <nw/snd/fnd/basis/sndfnd_Result.h>
#include <nw/snd/fnd/io/sndfnd_Stream.h>
#include <nw/snd/fnd/model/sndfnd_WaveFormat.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief  波形バイナリストリームを入力します。
//---------------------------------------------------------------------------
class WaveformStreamReader
{
    NW_DISALLOW_COPY_AND_ASSIGN(WaveformStreamReader);

public: // デストラクタ
    virtual ~WaveformStreamReader() { }

protected: // コンストラクタ
    WaveformStreamReader() { }

public: // メソッド
    virtual void Close() = 0;

    virtual bool IsOpened() const = 0;

    virtual bool IsHeaderRead() const = 0;

    virtual FndResult ReadHeader() = 0;
    virtual u32 ReadFrames(void* buffer, u32 frames, FndResult* result = NULL) = 0;

    virtual const WaveFormat& GetWaveFormat() const = 0;
    virtual u8 GetBlockAlignment() const = 0;
    virtual u32 GetDataSize() const = 0;
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_WAVEFORM_STREAM_H_
