﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_FILE_STREAM_H_
#define NW_SND_FND_FILE_STREAM_H_

#if defined(NW_PLATFORM_CAFE)
#include <cafe/fs.h>
#elif defined(NW_PLATFORM_CTR)
#include <nn/fs.h>
#elif defined(NW_USE_NINTENDO_SDK)
#include <nn/fs.h>
#endif

#include <nw/snd/fnd/io/sndfnd_Stream.h>
#include <nw/snd/fnd/basis/sndfnd_Result.h>

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//---------------------------------------------------------------------------
//! @brief  ファイルストリームです。
//---------------------------------------------------------------------------
class FileStream : public Stream
{
public:
    virtual ~FileStream() {}

public: // メソッド
#if defined(NW_PLATFORM_CAFE)
    virtual void Open(FSClient* fsClient, FSCmdBlock* fsCmdBlock, FSFileHandle fsFileHandle) = 0;
#elif defined(NW_PLATFORM_CTR)
    virtual nn::Result Open(const char* filePath, bit32 openMode) = 0;
#elif defined(NW_PLATFORM_WIN32) || defined(NW_PLATFORM_ANDROID)
    virtual void Open(void* fileHandle) = 0;
#elif defined(NW_USE_NINTENDO_SDK)
    virtual nn::Result Open(const char* filePath, nn::fs::OpenMode openMode) = 0;
#endif

    virtual void Close() = 0;

    virtual bool IsOpened() const = 0;

    virtual bool CanRead() const = 0;

    virtual bool CanWrite() const = 0;

    virtual bool CanSeek() const = 0;

    virtual u32 GetSize() const = 0;

    virtual u32 Read(void* buf, u32 length, FndResult* result = NULL) = 0;

    virtual u32 Write(const void* buf, u32 length, FndResult* result = NULL) = 0;

    virtual FndResult Seek(s32 offset, SeekOrigin origin) = 0;

    virtual u32 GetCurrentPosition() const = 0;

    virtual void EnableCache(void* buffer, u32 length) = 0;

    virtual void DisableCache() = 0;

    virtual bool IsCacheEnabled() const = 0;
};

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_FND_FILE_STREAM_H_
